﻿using System;
using System.ServiceModel;
using System.ServiceModel.Activation;
using Microsoft.ServiceBus;
using Microsoft.ServiceBus.Samples;

namespace AzureSample
{

    public class ServiceBusLogger
    {
        public ILogChannel Channel { get; set; }

        public ServiceBusLogger(string endPoint, string userName, string password)
        {

            Uri uri = new
            Uri(endPoint);
            TransportClientEndpointBehavior userNamePasswordServiceBusCredential = new
            TransportClientEndpointBehavior();
            userNamePasswordServiceBusCredential.CredentialType = TransportClientCredentialType.UserNamePassword;
            userNamePasswordServiceBusCredential.Credentials.UserName.UserName = userName;
            userNamePasswordServiceBusCredential.Credentials.UserName.Password = password;
            ChannelFactory<ILogChannel> channelFactory = new
            ChannelFactory<ILogChannel>();
            channelFactory.Endpoint.Address = new
            EndpointAddress(uri);
            channelFactory.Endpoint.Binding = new
            NetTcpRelayBinding();
            channelFactory.Endpoint.Contract.ContractType = typeof(ILogChannel);
            channelFactory.Endpoint.Behaviors.Add(userNamePasswordServiceBusCredential);
            this.Channel = channelFactory.CreateChannel();


        }


    }

    public class CalculatorClient
    {
        public ICalculator Channel { get; set; }

        public CalculatorClient(string endPoint, string userName, string password)
        {

            Uri uri = new
            Uri(endPoint);
            TransportClientEndpointBehavior userNamePasswordServiceBusCredential = new
            TransportClientEndpointBehavior();
            userNamePasswordServiceBusCredential.CredentialType = TransportClientCredentialType.UserNamePassword;
            userNamePasswordServiceBusCredential.Credentials.UserName.UserName = userName;
            userNamePasswordServiceBusCredential.Credentials.UserName.Password = password;
            ChannelFactory<ICalculatorChannel> channelFactory = new
            ChannelFactory<ICalculatorChannel>();
            channelFactory.Endpoint.Address = new
            EndpointAddress(uri);
            channelFactory.Endpoint.Binding = new
            NetTcpRelayBinding();
            channelFactory.Endpoint.Contract.ContractType = typeof(ICalculatorChannel);
            channelFactory.Endpoint.Behaviors.Add(userNamePasswordServiceBusCredential);
            this.Channel = channelFactory.CreateChannel();


        }


    }



}

